// component/telView/index.js
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    nodes: {
      type: String,
      value: ""
    },
    telColor: {
      type: String,
      value: ""
    }
  },

  /**
   * 组件的初始数据
   */
  data: {

  },
  ready: function() {
    this.dealNodes()

  },


  /**
   * 组件的方法列表
   */
  methods: {
    checkPhone: function(text) {
      return text.match(/((((13[0-9])|(15[^4])|(18[0,1,2,3,5-9])|(17[0-8])|(147))\d{8})|((\d3,4|\d{3,4}-|\s)?\d{7,14}))?/g);
    },
    dealNodes: function() {
      const nodes = this.data.nodes
      let resultList = this.checkPhone(nodes)
      resultList = resultList.slice(0, resultList.length - 1)
      let phoneNums = []
      for (let i = 0; i < resultList.length; i++) {
        if (resultList[i].length > 0) {
          const phoneNumItem = {}
          phoneNumItem.tel = resultList[i]
          phoneNumItem.index = i
          phoneNums.push(phoneNumItem)
        }
      }
      let nodesList = []
      if (phoneNums.length > 0) {
        let startIndex = 0
        let endIndex = phoneNums[0].index
        let dlength = 0
        for (let j = 0; j < phoneNums.length; j++) {

          const pItem = phoneNums[j]
          let str1 = ""

          if (startIndex != endIndex) {
            str1 = nodes.substring(startIndex, endIndex)
          }
          startIndex = endIndex + pItem.tel.length
          dlength += (pItem.tel.length - 1)
          if (j == phoneNums.length - 1) {
            endIndex = nodes.length
          } else {
            endIndex = dlength + phoneNums[j + 1].index
          }
          const item = {}
          item.text = str1
          item.show_type = 0 //0 纯文本展示 1 电话号码
          nodesList.push(item)
          const itemTel = {}
          itemTel.text = pItem.tel
          itemTel.show_type = 1 //0 纯文本展示 1 电话号码
          nodesList.push(itemTel)

          if (j == phoneNums.length - 1) {
            if (pItem.index < resultList.length - 1) {
              const endItem = {}

              const endStr = nodes.substring(startIndex, endIndex)
              endItem.text = endStr
              endItem.show_type = 0 //0 纯文本展示 1 电话号码
              nodesList.push(endItem)
            }

          }


        }



      } else {
        const item = {}
        item.text = nodes
        item.show_type = 0 //0 纯文本展示 1 电话号码
        nodesList.push(item)

      }
      this.setData({
        nodesList: nodesList
      })

    },
    makeCall: function(event) {
      const tel = event.currentTarget.id
      wx.makePhoneCall({
        phoneNumber: tel,
      })
    }

  }
})